import math, os, json

# check SHMDEF.json version
if os.path.exists("/etc/mcs/SHMDEF.json"):
    shmdef_exist = True
else:
    shmdef_exist = False

version_check = False
if shmdef_exist:
    try:
        from i611shm import shm_read, shm_read_version
        shmso_ver = shm_read_version()
        with open("/etc/mcs/SHMDEF.json", 'r') as f:
            shmdef = json.load(f)
        shmdef_ver = shmdef['version']
        if shmso_ver == shmdef_ver:
            version_check = True
        else:
            version_check = False
    except:
        version_check = False
else:
    from i611shm import shm_read

# region if SHMDEF exists or version matches with libi611shm.so
if version_check:
    '''Receiving data periodically from Shared memory '''
    # get shared memory address
    ADR_CMDX = shmdef['rbsts']['cmdx']['address_int']                       # 0~5 X,Y,Z,Rx,Ry,Rz
    ADR_POSTURE = shmdef['rbsts']['posture']['address_int']                 # 6 posture
    ADR_MULTITURN = shmdef['rbsts']['multiturn']['address_int']             # 7 multiturn
    ADR_JOINT = shmdef['rbsts']['joint'][0]['address_int']                  # 8~13 joint
    ADR_AXIS_TYPE = shmdef['rbcfg']['axis_type'][0]['address_int']          # - joint type (1 -> revolute type, 2 -> prismatic type)
    ADR_SINGULAR = shmdef['rbsts']['singular']['address_int']               # 14 singular point
    ADR_VEL_ERROR_AXES = shmdef['rbsts']['vel_error_axes']['address_int']   # 15 speed limit
    ADR_SOFTLIMIT = shmdef['rbsts']['softlimit']['address_int']             # 16 soft limit
    ADR_MIO_SI0 = shmdef['io']['mio_si0']['address_int']                    # 17 system SI
    ADR_MIO_SI2 = shmdef['io']['mio_si2']['address_int']                    # 18 system SI
    ADR_DIO_HANDIO = shmdef['io']['dio_handio']['address_int']              # 19 arm input/output
    ADR_MANIP_TYPE = shmdef['rbcfg']['manip_type'][0]['address_int']        # 20 manipulator type
    ADR_MANIP_SERIAL = shmdef['rbcfg']['manip_serial'][0]['address_int']    # 21 manipulator serial
    ADR_IN_RL = shmdef['io']['in_rl']['address_int']                        # 24 IN_R(L)
    ADR_IN_RH = shmdef['io']['in_rh']['address_int']                        # 25 IN_R(H)
    ADR_IN_X1 = shmdef['io']['in_x1']['address_int']                        # 26 IN_X1
    ADR_IN_X2 = shmdef['io']['in_x2']['address_int']                        # 27 IN_X2          
    ADR_OUT_RL = shmdef['io']['out_rl']['address_int']                      # 28 OUT_R(L)
    ADR_DIO_IO = shmdef['io']['dio_io']['address_int']                      # 29 D_IN(1~16) , D_OUT(17~32)
    ADR_ETHERCAT_INPUT = shmdef['io']['ethercat_input'][0]['address_int']   # 31 external Input 512~543 (32bit)
    ADR_ETHERCAT_OUTPUT = shmdef['io']['ethercat_output'][0]['address_int'] # 32 external Output 768~799 (32bit)
    ADR_ASSIGN_PORT = shmdef['sys']['assign_port'][4]['address_int']        # 33~40 assign port
    ADR_JOINT_AUX = shmdef['rbsts']['joint'][6]['address_int']              # 41~42 auxiliary joint (j7, j8)
    ADR_CMDAUX_12 = shmdef['rbsts']['cmdaux'][0]['address_int']             # 43~44 auxiliary position (ax1, ax2)
    ADR_CMDAUX_34 = shmdef['rbsts']['cmdaux2'][0]['address_int']            # 45~46 auxiliary position (ax3, ax4)
    ADR_RBCOORD = shmdef['rbsts']['coordinate']['address_int']              # 47 rbcoord

    # XY Coordinate Position
    data_list = shm_read(ADR_CMDX,6).split(',')  # 0 ~ 5
    data  = str(float(data_list[0]) * 1000)             # X
    data += "," + str(float(data_list[1]) * 1000)       # Y
    data += "," + str(float(data_list[2]) * 1000)       # Z
    data += "," + str(math.degrees(float(data_list[3])))# Rz
    data += "," + str(math.degrees(float(data_list[4])))# Ry
    data += "," + str(math.degrees(float(data_list[5])))# Rx

    # XY Coordinate Posture, Multiturn
    data_str = shm_read(ADR_POSTURE,1) # 6
    data += "," + data_str        # Posture
    data_str = shm_read(ADR_MULTITURN,1) # 7
    data += "," + data_str        # Multiturn
    # Joint Degree
    data_list = shm_read(ADR_JOINT,6).split(',') # 8~13
    # Joint Type (1 -> revolute type, 2 -> prismatic type)
    data_joint_type_list = shm_read(ADR_AXIS_TYPE,8).split(',')

    for i in range(6):
        if int(data_joint_type_list[i]) == 2:
            data += "," + str(float(data_list[i]) * 1000)           # prismatic type
        else :
            data += "," + str(math.degrees(float(data_list[i])))    # revolute type

    # Singular Point, Speed Limit, Soft Limit
    data_str = shm_read(ADR_SINGULAR,1) # 14
    data += "," + data_str        # Singular Point
    data_str = shm_read(ADR_VEL_ERROR_AXES,1) # 15
    data += "," + data_str        # Speed Limit
    data_str = shm_read(ADR_SOFTLIMIT,1) # 16
    data += "," + data_str        # Soft Limit

    # System SI
    data_str = shm_read(ADR_MIO_SI0,1)   # 17
                                    # Servo Status / EMS status / System error(C..) / ABS lost status 
                                    # OFF : 0      / OPEN : 0   / NO ERR : 0        / NO ERR : 0
    data += "," + data_str

    data_str = shm_read(ADR_MIO_SI2,1)   # 18
                                    # Robot Program status / System error(E..) / Pause status / System error(C,E) / System Status / Error Code
    data += "," + data_str

    data_str = shm_read(ADR_DIO_HANDIO,1)   # 19  Arm Input 0 ~ 15 , Arm Output 16 ~ 31(address = 32 ~ 63)
                                    # 8bytes type(1L = Arm Input, 1H = Arm Output) ->  7 = 00000000 00000000 00000000 00000111
                                    #                                                      [     1   H     ] [     1   L     ]
                                    # print     0  0  0  0  0  0  0  0       0  0  0  0  0  0  0  0       0  0  0  0  0  0  0  0       0  0  0  0  0  0  0  0
                                    # address   63 62 61 60 59 58 57 56      55 54 53 52 51 50 49 48      47 46 45 44 43 42 41 40      39 38 37 36 35 34 33 32
                                    # Arm   OUT:16 15 14 13 12 11 10 9       8  7  6  5  4  3  2  1    In:16 15 14 13 12 11 10 9       8  7  6  5  4  3  2  1
    data += "," + data_str

    data_str = shm_read(ADR_MANIP_TYPE,1)   # 20 Manipulator Type Information

    data += "," + data_str

    data_str = shm_read(ADR_MANIP_SERIAL,1)   # 21 Manipulator Serial Number Information

    data += "," + data_str

    fVer = "/opt/i611/version"
    fBuild = "/opt/i611/build"

    f1 = open(fVer, 'r')
    data_str = f1.read()
    f1.close()
    data += "," + data_str[:-1]     # 22 Robot System Version Information

    f2 = open(fBuild, 'r')
    data_str = f2.read()
    f2.close()
    data += "," + data_str[:-1]     # 23 Robot System Build Information


    # append status monitoring for teach mode control		# CT210121
    data_str = shm_read(ADR_IN_RL,1)   # 24 IN_R(L)        7       6       5       4       3       2       1       0
    data += "," + data_str          #                   ACPF    DCPF    RMT-ER  EMS-ER  SVON-ER WDER    ID1     ID0

    data_str = shm_read(ADR_IN_RH,1)   # 25 IN_R(H)        7       6       5       4       3       2       1       0
    data += "," + data_str          #                   -       MODE2   MODE1   EMS2    EMS1    SVON2   SVON1   ENABLE

    data_str = shm_read(ADR_IN_X1,1)   # 26 IN_X1          7       6       5       4       3       2       1       0
    data += "," + data_str          #                   -       -       -       PLC_ER  OH3     OH2     OH1     ID2

    data_str = shm_read(ADR_IN_X2,1)   # 27 IN_X2          7       6       5       4       3       2       1       0
    data += "," + data_str          #                   MODE2   MODE1   DOOR2   DOOR1   JOG_TCH JOG_RMT -       ID3

    data_str = shm_read(ADR_OUT_RL,1)   # 28 OUT_R(L)       7       6       5       4       3       2       1       0
    data += "," + data_str          #                   -       -       LED2    LED1    READY   SVEN    HS_EN2  HS_EN1

    data_str = shm_read(ADR_DIO_IO,1)   # 29 D_IN(1~16) , D_OUT(17~32)
    data += "," + data_str

    data_str = str(os.path.exists("/tmp/zeus_teach"))
    data += "," + data_str

    data_str = shm_read(ADR_ETHERCAT_INPUT,1)   # 31 external Input 512~543 (32bit)
    data += "," + data_str

    data_str = shm_read(ADR_ETHERCAT_OUTPUT,1)   # 32 external Output 768~799 (32bit)
    data += "," + data_str

    data_str = shm_read(ADR_ASSIGN_PORT, 8)  # 33 ~ 40 Assign Out value
    data += "," + data_str  # asgno_running   asgno_svon       asgno_emo        asgno_hw_err
                            # asgno_sw_err    asgno_abs_lost   asgno_in_pause   asgno_error

    data_list = shm_read(ADR_JOINT_AUX, 2).split(',') # 41 ~ 42 Auxiliary Joint (j7, j8)
    for i in range(6,8):
        if int(data_joint_type_list[i]) == 2:
            data += "," + str(float(data_list[i-6]) * 1000)           # prismatic type
        else :
            data += "," + str(math.degrees(float(data_list[i-6])))    # revolute type

    data_list = shm_read(ADR_CMDAUX_12, 2).split(',') # 43 ~ 44 Auxiliary axes (ax1, ax2)
    data += "," + str(float(data_list[0]) * 1000)             # Aux1
    data += "," + str(float(data_list[1]) * 1000)       # Aux2

    data_list = shm_read(ADR_CMDAUX_34, 2).split(',') # 45 ~ 46 Auxiliary axes (ax3, ax4)
    data += "," + str(float(data_list[0]) * 1000)             # Aux3
    data += "," + str(float(data_list[1]) * 1000)       # Aux4

    data_str = shm_read(ADR_RBCOORD, 1) # 47 rbcoord
    data += "," + data_str

    with open("/etc/mcs/HWDEF.json", 'r') as f: # 48 n_axes
        hwdef = json.load(f)
    data_str = str(hwdef['system']['n_axes'][0])
    data += "," + data_str

    data += ","
    print(data)     # Get print result as stdout of SSH and use it.

# endregion
# region if SHMDEF doesn't exist or version doesn't match with libi611shm.so
else:
    '''Receiving data periodically from Shared memory '''
    # XY Coordinate Position
    data_list = shm_read(0x3000,6).split(',')  # 0 ~ 5
    data = str(float(data_list[0]) * 1000)             # X
    data += "," + str(float(data_list[1]) * 1000)       # Y
    data += "," + str(float(data_list[2]) * 1000)       # Z
    data += "," + str(math.degrees(float(data_list[3])))# Rz
    data += "," + str(math.degrees(float(data_list[4])))# Ry
    data += "," + str(math.degrees(float(data_list[5])))# Rx

    # XY Coordinate Posture, Multiturn
    data_str = shm_read(0x3040,1) # 6
    data += "," + data_str        # Posture
    data_str = shm_read(0x304C,1) # 7
    data += "," + data_str        # Multiturn
    # Joint Degree
    data_list = shm_read(0x3050,6).split(',') # 8~13
    # Joint Type (1 -> revolute type, 2 -> prismatic type)
    data_joint_type_list = shm_read(0x2cdc,6).split(',')

    for i in range(6):
        if int(data_joint_type_list[i]) == 2:
            data += "," + str(float(data_list[i]) * 1000)           # prismatic type
        else :
            data += "," + str(math.degrees(float(data_list[i])))    # revolute type

    # Singular Point, Speed Limit, Soft Limit
    data_str = shm_read(0x3048,1) # 14
    data += "," + data_str        # Singular Point
    data_str = shm_read(0x3098,1) # 15
    data += "," + data_str        # Speed Limit
    data_str = shm_read(0x309C,1) # 16
    data += "," + data_str        # Soft Limit

    # System SI
    data_str = shm_read(0x0300,1)   # 17
                                    # Servo Status / EMS status / System error(C..) / ABS lost status 
                                    # OFF : 0      / OPEN : 0   / NO ERR : 0        / NO ERR : 0
    data += "," + data_str

    data_str = shm_read(0x0308,1)   # 18
                                    # Robot Program status / System error(E..) / Pause status / System error(C,E) / System Status / Error Code
    data += "," + data_str

    data_str = shm_read(0x0104,1)   # 19  Arm Input 0 ~ 15 , Arm Output 16 ~ 31(address = 32 ~ 63)
                                    # 8bytes type(1L = Arm Input, 1H = Arm Output) ->  7 = 00000000 00000000 00000000 00000111
                                    #                                                      [     1   H     ] [     1   L     ]
                                    # print     0  0  0  0  0  0  0  0       0  0  0  0  0  0  0  0       0  0  0  0  0  0  0  0       0  0  0  0  0  0  0  0
                                    # address   63 62 61 60 59 58 57 56      55 54 53 52 51 50 49 48      47 46 45 44 43 42 41 40      39 38 37 36 35 34 33 32
                                    # Arm   OUT:16 15 14 13 12 11 10 9       8  7  6  5  4  3  2  1    In:16 15 14 13 12 11 10 9       8  7  6  5  4  3  2  1
    data += "," + data_str

    data_str = shm_read(0x2C00,1)   # 20 Manipulator Type Information

    data += "," + data_str

    data_str = shm_read(0x2C24,1)   # 21 Manipulator Serial Number Information

    data += "," + data_str

    fVer = "/opt/i611/version"
    fBuild = "/opt/i611/build"

    f1 = open(fVer, 'r')
    data_str = f1.read()
    f1.close()
    data += "," + data_str[:-1]     # 22 Robot System Version Information

    f2 = open(fBuild, 'r')
    data_str = f2.read()
    f2.close()
    data += "," + data_str[:-1]     # 23 Robot System Build Information


    # append status monitoring for teach mode control		# CT210121
    data_str = shm_read(0x010E,1)   # 24 IN_R(L)        7       6       5       4       3       2       1       0
    data += "," + data_str          #                   ACPF    DCPF    RMT-ER  EMS-ER  SVON-ER WDER    ID1     ID0

    data_str = shm_read(0x010F,1)   # 25 IN_R(H)        7       6       5       4       3       2       1       0
    data += "," + data_str          #                   -       MODE2   MODE1   EMS2    EMS1    SVON2   SVON1   ENABLE

    data_str = shm_read(0x0114,1)   # 26 IN_X1          7       6       5       4       3       2       1       0
    data += "," + data_str          #                   -       -       -       PLC_ER  OH3     OH2     OH1     ID2

    data_str = shm_read(0x0115,1)   # 27 IN_X2          7       6       5       4       3       2       1       0
    data += "," + data_str          #                   MODE2   MODE1   DOOR2   DOOR1   JOG_TCH JOG_RMT -       ID3

    data_str = shm_read(0x0110,1)   # 28 OUT_R(L)       7       6       5       4       3       2       1       0
    data += "," + data_str          #                   -       -       LED2    LED1    READY   SVEN    HS_EN2  HS_EN1

    data_str = shm_read(0x0100,1)   # 29 D_IN(1~16) , D_OUT(17~32)
    data += "," + data_str

    data_str = str(os.path.exists("/tmp/zeus_teach"))
    data += "," + data_str

    data_str = shm_read(0x0140,1)   # 31 external Input 512~543 (32bit)
    data += "," + data_str

    data_str = shm_read(0x0160,1)   # 32 external Output 768~799 (32bit)
    data += "," + data_str

    data_str = shm_read(0x084C, 8)  # 33 ~ 40 Assign Out value
    data += "," + data_str          # asgno_running   asgno_svon       asgno_emo        asgno_hw_err
                                    # asgno_sw_err    asgno_abs_lost   asgno_in_pause   asgno_error

    # 41 ~ 42 Auxiliary Joint (j7, j8) (Not supported)
    data += ",0.0" # J7
    data += ",0.0" # J8

    # 43 ~ 44 Auxiliary axes (ax1, ax2) (Not supported)
    data += ",0.0" # ax1
    data += ",0.0" # ax2
    
    # 45 ~ 46 Auxiliary axes (ax3, ax4) (Not supported)
    data += ",0.0" # ax3
    data += ",0.0" # ax4

    data_str = shm_read(0x3044, 1) # 47 rbcoord
    if data_str != "":
        data += "," + data_str
    else:
        data += ",1"

    with open("/etc/mcs/HWDEF.json", 'r') as f: # 48 n_axes
        hwdef = json.load(f)
    data_str = str(hwdef['system']['n_axes'][0])
    data += "," + data_str
    
    data += ","
    print(data)     # Get print result as stdout of SSH and use it.

# endregion


